﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe.HelperClasses
{
    // remove public access
    [Serializable]
    static class KeyHelper
    {

        #region /*** Ctors ***/

        static KeyHelper()
        {
            Keys = new ulong[MaxKeys];
            for (int i = 0; i < MaxKeys; i++)
            {
                Keys[i] = 1UL << i;
            }
        }

        #endregion

        #region /*** Methods ***/

        /// <summary>
        /// Builds a 64-bit key from the specified indexes.
        /// </summary>
        /// <param name="indexes">One or more indexes, ranged 0 to 63, from which to compute a 64-bit key.</param>
        /// <returns>A 64-bit key.</returns>
        public static ulong BuildKey(params int[] indexes)
        {
            if (indexes == null) { return 0; }
            ulong key = 0;
            for (int i = 0; i < indexes.Length; i++)
            {
                key |= Keys[indexes[i]];
            }
            return key;
        }

        /// <summary>
        /// Builds a 64-bit key from the specified array of key states.
        /// </summary>
        /// <param name="state">An array of states, with a maximum length of 64, from which to compute a 64-bit key.</param>
        /// <returns>A 64-bit key.</returns>
        public static ulong BuildKey(bool[] state)
        {
            if (state == null) { return 0; }
            ulong key = 0;
            for (int i = 0; i < state.Length; i++)
            {
                if (state[i])
                {
                    key |= Keys[i];
                }
            }
            return key;
        }


        #endregion

        #region /*** Variables ***/

        const int MaxKeys = 64;

        /// <summary>Provides an array of pre-calculated keys corresponding to the expanded values of 2^n for each index in the array. That is, Keys[0]=1 (2^0);
        ///   Keys[1]=2 (2^1); Keys[2]=4 (2^2); Keys[3]=8 (2^3); Keys[4]=16 (2^4); and so on. The array contains a maximum of 64 pre-calculated values, where
        ///   the last element is Keys[63]=9,223,372,036,854,775,808 (2^63).</summary>
        public static readonly ulong[] Keys;

        #endregion

    }
}
