using System;

namespace Volpe.Cafe.IO.Reporting.XL
{
	/// <summary>
	/// The exception that is thrown when an error occurs while generating an Excel report.
	/// </summary>
    [Serializable]
    public class XlReportingException : Exception
	{

        #region /*** Constructors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="XlReportingException"/> class with the file name that was being written
        /// when the exception occured.
        /// </summary>
        /// <param name="fileName">The name of the file that was being written when the exception occured.</param>
        public XlReportingException(string fileName)
            : this(string.Empty, fileName)
        {
        }
        /// <summary>
        /// Initializes a new instance of the <see cref="XlReportingException"/> class with the specified message and the file
        /// name that was being written when the exception occured.
        /// </summary>
        /// <param name="message">The error message that explains the reason for the exception.</param>
        /// <param name="fileName">The name of the file that was being written when the exception occured.</param>
        public XlReportingException(string message, string fileName)
            : this(message, fileName, null)
        {
        }
        /// <summary>
        /// Initializes a new instance of the <see cref="XlReportingException"/> class with the specified message, the file name
        /// that was being written when the exception occured, and a reference to the inner exception that is the cause of this
        /// exception.
        /// </summary>
        /// <param name="message">The error message that explains the reason for the exception.</param>
        /// <param name="fileName">The name of the file that was being written when the exception occured.</param>
        /// <param name="innerException">The exception that is the cause of the current exception.  If the innerException
        ///   parameter is not null, the current exception is raised in a catch block that handles the inner exception.</param>
        public XlReportingException(string message, string fileName, Exception innerException)
            : base("Error writing file: " + fileName + "\nAdditional information: " + message, innerException)
        {
            this._fileName = fileName;
        }

        #endregion


        #region /*** Properties ***/

        /// <summary>Gets the name of the file that was being written when the exception occured.</summary>
        public string FileName { get { return this._fileName; } }

        #endregion


        #region /*** Variables ***/

        string _fileName;

        #endregion

	}
}
